package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.usermgmt.bizobj.BusinessObjectFactory;
import gov.va.med.mhv.usermgmt.bizobj.HealthSummaryBO;
import gov.va.med.mhv.usermgmt.bizobj.HealthSummaryStatusAssembler;
import gov.va.med.mhv.usermgmt.bizobj.HealthSummaryStatusBO;
import gov.va.med.mhv.usermgmt.service.HealthSummaryStatusServiceResponse;
import java.lang.Long;
import java.lang.String;
import java.util.List;

import org.tigris.atlas.messages.DefaultMessage;

import gov.va.med.mhv.usermgmt.service.HealthSummaryStatusService;
import gov.va.med.mhv.usermgmt.transfer.HealthSummary;
import gov.va.med.mhv.usermgmt.transfer.HealthSummaryStatus;

/**
 * Service implementation class for the HealthSummaryStatus service
 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryStatusService
 */
public class HealthSummaryStatusServiceImpl implements HealthSummaryStatusService {

	/**
	 * Execute the SaveHealthSummaryStatus service
	 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryStatusService#SaveHealthSummaryStatus()
	 */
	public HealthSummaryStatusServiceResponse saveHealthSummaryStatus(String name, String description) {
		HealthSummaryStatusServiceResponse response = new HealthSummaryStatusServiceResponse();
		try {
			HealthSummaryStatus healthSummaryStatus = new HealthSummaryStatus();
			healthSummaryStatus.setName(name);
			healthSummaryStatus.setDescription(description);
			HealthSummaryStatusBO bo = BusinessObjectFactory.createHealthSummaryStatusBO();
			bo.setHealthSummaryStatusValues(healthSummaryStatus);
			bo.save();
			if( bo.getAllMessages( ).hasErrorMessages( ) ) {	     
	            response.getMessages( ).addMessages( bo.getAllMessages( ) );
	        }	
		}
		catch(Exception x)
		{
			DefaultMessage msg = new DefaultMessage();
			msg.addProperty(x.getLocalizedMessage());
			response.getMessages().addMessage(msg);
		}
		return response;
	}


	/**
	 * Execute the GetHealthSummaryStatusByName service
	 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryStatusService#GetHealthSummaryStatusByName()
	 */
	public HealthSummaryStatusServiceResponse getHealthSummaryStatusByName(String name) {
		HealthSummaryStatusServiceResponse response = new HealthSummaryStatusServiceResponse();
		List<HealthSummaryStatusBO> healthSummaryStatusList = HealthSummaryStatusBO.getHealthSummaryStatusByName(name);
		if(healthSummaryStatusList.size() > 0) {
			HealthSummaryStatusBO hsbo = (HealthSummaryStatusBO) healthSummaryStatusList.get(0);
			HealthSummaryStatus hss = new HealthSummaryStatusAssembler().createHealthSummaryStatus(hsbo);
			response.setHealthSummaryStatus(hss);
		}
		return response;
	}


	/**
	 * Execute the GetHealthSummaryStatusById service
	 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryStatusService#GetHealthSummaryStatusById()
	 */
	public HealthSummaryStatusServiceResponse getHealthSummaryStatusById(Long id) {
		HealthSummaryStatusServiceResponse response = new HealthSummaryStatusServiceResponse();
		List<HealthSummaryStatusBO> healthSummaryStatusList = HealthSummaryStatusBO.getHealthSummaryStatusById(id);
		if(healthSummaryStatusList.size() > 0) {
			HealthSummaryStatusBO hsbo = (HealthSummaryStatusBO) healthSummaryStatusList.get(0);
			HealthSummaryStatus hss = new HealthSummaryStatusAssembler().createHealthSummaryStatus(hsbo);
			response.setHealthSummaryStatus(hss);
		}
		return response;
	}

}